﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;

namespace AHOBPR_Job_Runner.DasXml
{
    [Serializable]
    public class Person
    {
        public DateTime? BirthDate { get; set; }
        public String GivenName { get; set; }
        public String MiddleName { get; set; }
        public String Surname { get; set; }
        public String Sex { get; set; } 
        public String Ssn { get; set; }
        public MilitarySummary CurrentMilitarySummary { get; set; }
        public MilitarySummary QualifyingMilitarySummary { get; set; }

        public Person()
        {
            CurrentMilitarySummary = new MilitarySummary() { MilitaryStatus = MilitaryStatusEnum.Current };
            QualifyingMilitarySummary = new MilitarySummary() { MilitaryStatus = MilitaryStatusEnum.Qualifying };
        }


        public void GetXml(XmlWriter writer)
        {
            String prefix = "nc";
            writer.WriteStartElement(prefix, "Person", prefix);
            writer.WriteAttributeString("s", "id", "s", "p1");
            writer.WriteWhitespace("\r\n\t\t\t");

            //Birth Date:
            {
                if (BirthDate.HasValue)
                {
                    writer.WriteStartElement(prefix, "PersonBirthDate", prefix);
                    writer.WriteWhitespace("\r\n\t\t\t\t");
                    {
                        writer.WriteDate(prefix, BirthDate.Value);
                    }
                    writer.WriteEndElement();
                }
            }

            //Military Summaries:
            writer.WriteWhitespace("\r\n\t\t\t");
            CurrentMilitarySummary.GetXml(writer);
            writer.WriteWhitespace("\r\n\t\t\t");
            QualifyingMilitarySummary.GetXml(writer);

            //Name:
            {
                writer.WriteWhitespace("\r\n\t\t\t");
                writer.WriteStartElement(prefix, "PersonName", prefix);
                writer.WriteWhitespace("\r\n\t\t\t\t");


                //Given Name:
                {
                    writer.WriteElementString(prefix, "PersonGivenName", prefix, GivenName);
                    writer.WriteWhitespace("\r\n\t\t\t\t");
                }

                //Middle Name:
                {
                    writer.WriteElementString(prefix, "PersonMiddleName", prefix, MiddleName);
                    writer.WriteWhitespace("\r\n\t\t\t\t");
                }

                //Surname:
                {
                    writer.WriteElementString(prefix, "PersonSurName", prefix, Surname);
                    writer.WriteWhitespace("\r\n\t\t\t");
                }

                writer.WriteEndElement();
                writer.WriteWhitespace("\r\n\t\t\t");
            }

            //Sex:
            {
                writer.WriteElementString(prefix, "PersonSexCode", prefix, Sex);
                writer.WriteWhitespace("\r\n\t\t\t");
            }

            //SSN:
            {
                writer.WriteStartElement(prefix, "PersonSSNIdentification", prefix);
                writer.WriteWhitespace("\r\n\t\t\t\t");
                {
                    writer.WriteElementString(prefix, "IdentificationID", prefix, Ssn);
                    writer.WriteWhitespace("\r\n\t\t\t");
                }
                writer.WriteEndElement();
                writer.WriteWhitespace("\r\n\t\t");
            }

            writer.WriteEndElement();
            writer.WriteWhitespace("\r\n\t\t");
        }
    }
}